package boot;

public class BootDataPacket {
	private static final int BOOT_EP_SIZE = 64;
	public static final int OVER_HEAD = 5 ; //<CMD><LEN><ADR:3>
	private static final int DATA_SIZE = BOOT_EP_SIZE - OVER_HEAD;
	public static final byte READ_VERSION = 0x00;
	public static final byte READ_FLASH = 0x01;
	public static final byte WRITE_FLASH = 0x02;
	public static final byte ERASE_FLASH = 0x03;
	public static final byte READ_EEDATA = 0x04;
	public static final byte WRITE_EEDATA = 0x05;
	public static final byte READ_CONFIG = 0x06;
	public static final byte WRITE_CONFIG = 0x07;
	public static final byte UPDATE_LED = 0x32;
	public static final byte RESET = (byte)0xFF;
	
	byte cmd;
	byte len;
	byte adr_low;
	byte adr_high;
	byte adr_upper;
	byte[] data;
	
	public BootDataPacket(byte cmd, int address,int len, byte[] data) {
		super();
		// TODO Auto-generated constructor stub
		//si el bootdatapacket es de writeFlash, lo relleno con FF hasta llegar a longitud de 16
		if (cmd==WRITE_FLASH && len!=16){
			this.len=16;
			this.data = new byte[16];
			for(int i=0;i<16;i++){
				if (i<len){
					this.data[i]=data[i];
				}
				else {
					this.data[i]=(byte)0xff;
				}
			}
		}
		else {
			this.len=(byte)len;
			this.data = data;
		}
		this.cmd = cmd;
		adr_low = (byte)(address % 256);
		adr_high = (byte)((address / 256) % 256);
		adr_upper = (byte)( address / 65536);
		
	}
	public BootDataPacket(){
		
	}
	public BootDataPacket(int dataSize){
		data = new byte[dataSize];
		len = (byte)dataSize;
	}
	
	public byte[] getPacket(){
		
		byte[] packet;
		if (data!=null){
			if (cmd==READ_VERSION) {
				packet = new byte[data.length];
			}
			else {
				packet = new byte[data.length+ OVER_HEAD];
			}
		}
		else packet = new byte[this.len];
		if (len>0) packet[0] = cmd;
		if (len>1) packet[1] = len;
		if (len>2) packet[2] = adr_low;
		if (len>3) packet[3] = adr_high;
		if (len>4) packet[4] = adr_upper;
		if (len>5 && data!=null){
			for (int i=0; i<data.length; i++){
				packet[i+OVER_HEAD] = data[i];
			}
		}
		return packet;
	}
	
	public void printBinData(){
		byte[] c=this.getPacket();
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
	
	public byte[] getCommand(){
		byte[] packet;
		if (data!=null){
			if (data[0]==READ_VERSION) packet = new byte[data.length];
			else packet = new byte[data.length+ OVER_HEAD];
		}
		else packet = new byte[5];
		/*// da problemas al generar read que quiero leer menos de 5 bytes
		if (len>0) packet[0] = cmd;
		if (len>1) packet[1] = len;
		if (len>2) packet[2] = adr_low;
		if (len>3) packet[3] = adr_high;
		if (len>4) packet[4] = adr_upper;
		*/
		packet[0] = cmd;
		packet[1] = len;
		packet[2] = adr_low;
		packet[3] = adr_high;
		packet[4] = adr_upper;
		
		return packet;
	}
	
	public void parse(byte[] s){
		data=s;
		if (s!=null){
			cmd = s[0];
			if (s.length>1) len = s[1];
			if (s.length>2) adr_low = s[2];
			if (s.length>3) adr_high = s[3];
			if (s.length>4) adr_upper = s[4];
			if (s.length>OVER_HEAD){
				data = new byte[s.length-OVER_HEAD];
				for (int i=0; i<s.length - OVER_HEAD; i++){
					data[i]=s[i+OVER_HEAD];
				}
			}
		}
	}

	public byte getAdr_high() {
		return adr_high;
	}

	public void setAdr_high(byte adr_high) {
		this.adr_high = adr_high;
	}

	public byte getAdr_low() {
		return adr_low;
	}

	public void setAdr_low(byte adr_low) {
		this.adr_low = adr_low;
	}

	public byte getAdr_upper() {
		return adr_upper;
	}

	public void setAdr_upper(byte adr_upper) {
		this.adr_upper = adr_upper;
	}

	public byte getCmd() {
		return cmd;
	}

	public void setCmd(byte cmd) {
		this.cmd = cmd;
	}

	public byte[] getData() {
		return data;
	}

	public void setData(byte[] data) {
		this.data = data;
		
	}

	public byte getLen() {
		return len;
	}

	public void setLen(byte len) {
		this.len = len;
	}
}
